/*
 *
 * Subclassowanie
 *
 */
#include <windows.h>
#include <string.h>

/* Deklaracja wyprzedzajca: funkcja obsugi okna */
WNDPROC lpEditOldWndProc = NULL;
LRESULT CALLBACK WindowProcedure(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK EditWindowProcedure(HWND hwnd, UINT message, 
                                 WPARAM wParam, LPARAM lParam);

/* Nazwa klasy okna */
char szClassName[] = "PRZYKLAD";

int WINAPI WinMain(HINSTANCE hThisInstance, HINSTANCE hPrevInstance, 
                   LPSTR lpszArgument, int nFunsterStil)
{
    HWND hwnd;               /* Uchwyt okna */
    MSG messages;            /* Komunikaty okna */
    WNDCLASSEX wincl;        /* Struktura klasy okna */

    /* Klasa okna */
    wincl.hInstance     = hThisInstance;
    wincl.lpszClassName = szClassName;
    wincl.lpfnWndProc   = WindowProcedure;    // wskanik na funkcj 
                                              // obsugi okna  
    wincl.style         = CS_DBLCLKS;                 
    wincl.cbSize        = sizeof(WNDCLASSEX);

    /* Domylna ikona i wskanik myszy */
    wincl.hIcon   = LoadIcon(NULL, IDI_APPLICATION);
    wincl.hIconSm = LoadIcon(NULL, IDI_APPLICATION);
    wincl.hCursor = LoadCursor(NULL, IDC_ARROW);
    wincl.lpszMenuName = NULL; 
    wincl.cbClsExtra = 0;   
    wincl.cbWndExtra = 0;   
    /* Jasnoszare to */
    wincl.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);

    /* Rejestruj klas okna */
    if(!RegisterClassEx(&wincl)) return 0;

    /* Twrz okno */
    hwnd = CreateWindowEx(
           0,                   
           szClassName,         
           "PRZYKLAD",       
           WS_OVERLAPPEDWINDOW, 
           CW_USEDEFAULT,       
           CW_USEDEFAULT,       
           CW_USEDEFAULT,       
           CW_USEDEFAULT,       
           HWND_DESKTOP,        
           NULL,                
           hThisInstance,       
           NULL                 
           );

    ShowWindow(hwnd, nFunsterStil);
    /* Ptla obsugi komunikatw */
    while(GetMessage(&messages, NULL, 0, 0))
    {
           /* Tumacz kody rozszerzone */
           TranslateMessage(&messages);
           /* Obsu komunikat */
           DispatchMessage(&messages);
    }

    /* Zwr parametr podany w PostQuitMessage( ) */
    return messages.wParam;
}

int xSize, ySize;

/* T funkcj woa DispatchMessage( ) */
LRESULT CALLBACK WindowProcedure(HWND hwnd, UINT message, 
                                 WPARAM wParam, LPARAM lParam)
{
    static HWND hwndEdit;
    static int  cxChar, cyChar;  
    static      RECT r;
    HDC         hdc; 
    int         i;
    PAINTSTRUCT ps;

    TCHAR       szFormat[] = TEXT ("%-16s Akcja: %04X,ID:%04X,hWnd:%08X");
    TCHAR       szBuffer[80];
    
    switch (message)                  
    {
           case WM_CREATE :
                cxChar = LOWORD (GetDialogBaseUnits ()) ;
                cyChar = HIWORD (GetDialogBaseUnits ()) ;
          
                hwndEdit = CreateWindow ( "EDIT", 
                                   "TEXTBOX",
                                   WS_CHILD | WS_VISIBLE | WS_BORDER | 
                                   ES_MULTILINE,
                                   cxChar, cyChar,
                                   20 * cxChar, 7 * cyChar,
                                   hwnd, (HMENU)1,
                                   ((LPCREATESTRUCT) lParam)->hInstance, 
                                   NULL) ;

              // zapamitaj star i ustal now funkcj
              // obsugi komunikatw.
              lpEditOldWndProc = GetWindowLong( hwndEdit, GWL_WNDPROC );
              SetWindowLong( hwndEdit, GWL_WNDPROC, EditWindowProcedure );
                                                                      
              break;
           case WM_DESTROY:
              PostQuitMessage(0);        
              break;
           case WM_SIZE:
              xSize = LOWORD(lParam); 
              ySize = HIWORD(lParam); 
              
              r.left   = 24 * cxChar ;
              r.top    =  2 * cyChar ;
              r.right  = LOWORD (lParam) ;
              r.bottom = HIWORD (lParam) ;
              
              break;   
           case WM_COMMAND:
              hdc = GetDC (hwnd);
     
              ScrollWindow (hwnd, 0, -cyChar, &r, &r) ;              
              SelectObject (hdc, GetStockObject (SYSTEM_FIXED_FONT)) ;
          
              SetBkMode (hdc, TRANSPARENT) ;
              TextOut (hdc, 24 * cxChar, cyChar * (r.bottom / cyChar - 1),
                         szBuffer,
                         wsprintf (szBuffer, szFormat,
                         "WM_COMMAND",
                         HIWORD (wParam), LOWORD (wParam), lParam ));

              ReleaseDC( hwnd, hdc );                
              return DefWindowProc(hwnd, message, wParam, lParam);
           case WM_PAINT:
              hdc = BeginPaint (hwnd, &ps);  
              EndPaint( hwnd, &ps );
              break;   
              
           default:                   
              return DefWindowProc(hwnd, message, wParam, lParam);
    }
    return 0;
}

// nowa funkcja obsugi komunikatw okna potomnego - pola tekstowego
LRESULT CALLBACK EditWindowProcedure(HWND hwnd, UINT message, 
                                 WPARAM wParam, LPARAM lParam)
{
    switch (message)                  
    {
           case WM_RBUTTONDOWN  :  
                SetWindowText( hwnd, "NOWYTEXT" );
                break;
           case WM_LBUTTONDBLCLK : 
                MessageBox( 0, "DoubleClick", "", 0 );
                break; 
    }
    // koniecznie pamitajmy o zawoaniu starej funkcji
    // obsugi komunikatw!
    return CallWindowProc( lpEditOldWndProc, hwnd, message, 
                           wParam, lParam );
}
